// CrackMe1 - Demonstracja zabezpieczenia poprzez weryfikacj numeru seryjnego
// KolorDlgs.cpp - obsuga okien dialogowych zwizanych z kolorami

#include "stdafx.h"
#include "resource.h"
#include "HelloCpp.h"
#include "KolorDlgs.h"

// Obsuga okna dialogowego kolor ta
INT_PTR CALLBACK KolorTla(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		SetTloRadiobuttonsState(hDlg);
		return (INT_PTR)TRUE;
	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		// obsuga przyciskw radiobutton
		else if (LOWORD(wParam) == IDC_RADIO_TLA_BIALY)
			clrKolorTla = 0xFFFFFF;
		else if (LOWORD(wParam) == IDC_RADIO_TLA_CZERWONY)
			clrKolorTla = 0x0000FF;
		else if (LOWORD(wParam) == IDC_RADIO_TLA_SZARY)
			clrKolorTla = 0x808080;
		else if (LOWORD(wParam) == IDC_RADIO_TLA_ZIELONY)
			clrKolorTla = 0x00FF00;
		else if (LOWORD(wParam) == IDC_RADIO_TLA_ZOLTY)
			clrKolorTla = 0x00FFFF;
		SetTloRadiobuttonsState(hDlg);
		break;
	}
	return (INT_PTR)FALSE;
}

// Ustawienie aktywnego przycisku z kolorem ta na podstawie clrKolorTla
void SetTloRadiobuttonsState(HWND hDlg)
{
	SendDlgItemMessage(hDlg, IDC_RADIO_TLA_BIALY, BM_SETCHECK, 0, 0);
	SendDlgItemMessage(hDlg, IDC_RADIO_TLA_CZERWONY, BM_SETCHECK, 0, 0);
	SendDlgItemMessage(hDlg, IDC_RADIO_TLA_SZARY, BM_SETCHECK, 0, 0);
	SendDlgItemMessage(hDlg, IDC_RADIO_TLA_ZIELONY, BM_SETCHECK, 0, 0);
	SendDlgItemMessage(hDlg, IDC_RADIO_TLA_ZOLTY, BM_SETCHECK, 0, 0);
	switch(clrKolorTla)
	{
	case 0xFFFFFF:
		SendDlgItemMessage(hDlg, IDC_RADIO_TLA_BIALY, BM_SETCHECK, 1, 0);
		break;
	case 0x0000FF:
		SendDlgItemMessage(hDlg, IDC_RADIO_TLA_CZERWONY, BM_SETCHECK, 1, 0);
		break;
	case 0x808080:
		SendDlgItemMessage(hDlg, IDC_RADIO_TLA_SZARY, BM_SETCHECK, 1, 0);
		break;
	case 0x00FF00:
		SendDlgItemMessage(hDlg, IDC_RADIO_TLA_ZIELONY, BM_SETCHECK, 1, 0);
		break;
	case 0x00FFFF:
		SendDlgItemMessage(hDlg, IDC_RADIO_TLA_ZOLTY, BM_SETCHECK, 1, 0);
		break;
	}
}

// Obsuga okna dialogowego kolor tekstu
INT_PTR CALLBACK KolorTekstu(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		SetTekstRadiobuttonsState(hDlg);
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		// obsuga przyciskw radiobutton
		else if (LOWORD(wParam) == IDC_RADIO_TEKST_CZARNY)
			clrKolorTekstu = 0;
		else if (LOWORD(wParam) == IDC_RADIO_TEKST_CZERWONY)
			clrKolorTekstu = 0x0000FF;
		else if (LOWORD(wParam) == IDC_RADIO_TEKST_NIEBIESKI)
			clrKolorTekstu = 0xFF0000;
		else if (LOWORD(wParam) == IDC_RADIO_TEKST_SZARY)
			clrKolorTekstu = 0x808080;
		else if (LOWORD(wParam) == IDC_RADIO_TEKST_ZIELONY)
			clrKolorTekstu = 0x00FF00;
		SetTekstRadiobuttonsState(hDlg);
		break;
	}
	return (INT_PTR)FALSE;
}

// Ustawienie aktywnego przycisku z kolorem tekstu na podstawie clrKolorTekstu
void SetTekstRadiobuttonsState(HWND hDlg)
{
	SendDlgItemMessage(hDlg, IDC_RADIO_TEKST_CZARNY, BM_SETCHECK, 0, 0);
	SendDlgItemMessage(hDlg, IDC_RADIO_TEKST_CZERWONY, BM_SETCHECK, 0, 0);
	SendDlgItemMessage(hDlg, IDC_RADIO_TEKST_NIEBIESKI, BM_SETCHECK, 0, 0);
	SendDlgItemMessage(hDlg, IDC_RADIO_TEKST_SZARY, BM_SETCHECK, 0, 0);
	SendDlgItemMessage(hDlg, IDC_RADIO_TEKST_ZIELONY, BM_SETCHECK, 0, 0);
	switch(clrKolorTekstu)
	{
	case 0:
		SendDlgItemMessage(hDlg, IDC_RADIO_TEKST_CZARNY, BM_SETCHECK, 1, 0);
		break;
	case 0x0000FF:
		SendDlgItemMessage(hDlg, IDC_RADIO_TEKST_CZERWONY, BM_SETCHECK, 1, 0);
		break;
	case 0xFF0000:
		SendDlgItemMessage(hDlg, IDC_RADIO_TEKST_NIEBIESKI, BM_SETCHECK, 1, 0);
		break;
	case 0x808080:
		SendDlgItemMessage(hDlg, IDC_RADIO_TEKST_SZARY, BM_SETCHECK, 1, 0);
		break;
	case 0x00FF00:
		SendDlgItemMessage(hDlg, IDC_RADIO_TEKST_ZIELONY, BM_SETCHECK, 1, 0);
		break;
	}
}
